// bergmark - spring 1999 - ITX project

import java.io.*;
import cnrg.itx.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

public class WhereAmI extends AbstractSignalingObserver {
   private final String adm = "db35@cornell.edu";
   private final String pw = "cnrgdb35";
   private String id = null;
   private DesktopSignaling myDS = null;
   private DataOutputStream out = null;                        


   // Default constructor
   public WhereAmI (String[] args) {
      if ( args.length != 1 ) {
	 System.out.println ("syntax: WhereAmI <login>");
	 System.exit(0);
      }
      // Get a signaling object
      try {
	 myDS = new DesktopSignaling ( this, adm, pw );
      } catch ( Exception e ) {
	 System.out.println ("Couldn't authenticate because" +
	    e.toString() );
	 System.exit(0);
      }
      System.out.println ("Got a DesktopSignling!");
      id = args[0];
      System.out.println ("Looking up extension for id = " + id );
   }

   // this method takes a user name and prints the extension
   private void PrintExtension (String who) {
      try {
	 System.out.println ("\n\nExtension for " + who + ": " +
	    myDS.getDirectory().getExtension(new UserID(who)).toString() + 
	    "\n\n" );
      } catch ( Exception e ) {
	   System.out.println ("\n\nUnable to look up the extension because " +
	    e.toString() );
      }
   }

   // This method prints the user whose extension is ext
   private void printUser ( String ext ) {
      try {
	 System.out.println ("\n\nUser at extension " + ext + ": " +
	 myDS.getDirectory().getID(new Digits(ext)).toString() +
	 "\n\n" );
      } catch ( Exception e ) {
	 System.out.println ("Could not find a user at extension " + ext +
	 " because " + e.toString() );
      }
   }

   // This method logs us out
   private void fini () {
      try {
	 out.flush();
	 out.close();
      } catch ( Exception e ) {}
      myDS.logout();
   }

   // Main program
   public static void main (String[] args) {
      WhereAmI me = new WhereAmI (args);
      me.PrintExtension (me.id);
      me.fini();            
      }
}
